require( "HiddenObject/script/style.lua" );

SliderFont = {
  standardFont,
  16,
  WhiteColor
};

HeaderFont = {
  standardFont,
  32,
  WhiteColor
};

ButtonFont = {
  standardFont,
  24,
  WhiteColor
};

CheckBoxFont = {
  standardFont,
  8,
  WhiteColor
};

FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	font = ButtonFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 340; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 105; end
	return y;
end

MakeDialog
{
	-- Name the modal dialog
	name="optionsmenu",
	Bitmap
	{
		image="HiddenObject/UI/background/optionsdialog",
		x = GetWindowX(),
		y = GetWindowY(),
		
		
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			
			Text
			{
				font = StandardHeaderFont,
				h = 40,
				name = "options",
				x=kCenter,y=20,w=kMax,h=37,
				flags = kHAlignCenter + kVAlignCenter,
				label = "options"
			};
			
			
			Text
			{
				font = SliderFont,
				name = "sfx",
				x=kCeter,y=70,w=kMax,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "sfxlevel"
			};
		
			Text
			{
				font = SliderFont,
				name = "fullscreentogglemessage",
				x=kCenter,y=210,w=kMax,h=60,
				flags = kHAlignCenter + kVAlignCenter,
				label = "fullscreentogglemessage"
			};
			
			Text
			{
				font = SliderFont,
				name = "music",
				x=kCenter,y=140,w=kMax,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "musiclevel"
			};
			

			SetStyle(CheckboxButtonStyle),			
			Button{
				name="fullscreen",
				x=kCenter + 20,
				y=260,
				w=180,
				h=32,
				Text
				{
					font = StandardButtonFont,
					name = "fullscreenlabel",
					x=65,
					y=8,
					w=kMax,
					h=32,
					flags = kHAlignLeft + kVAlignTop,
					label="fullscreen",
				};
				
			};
			
			Button{
				name="mutebox",
				x=kCenter + 10,
				y=310,
				w=160,
				h=32,
				Text
				{
					font = StandardButtonFont,
					name = "mutesoundlabel",
					x=65,
					y=8,
					w=100,
					h=32,
					flags = kHAlignLeft + kVAlignTop,
					label="mutesound",
				};
				command =
					function()
						ToggleSoundMute();
					end
			};

			SetStyle(FooterStyle),
			Button
			{
				x = kCenter-80,
				y = -80,
				name="apply",
				label="apply",
				type = kPush,
				font = StandardButtonFont,
				command =
					function()
						SaveVolumes();
						OnApply();
						PopModal("optionsmenu");
					end
			},
			
			--SetStyle(RightCurveStyle),
			Button
			{
				x = kCenter+80,
				y = -80,
				name="reset",
				label="reset",
				type = kPush,
				font = StandardButtonFont,
				command =
					function()
						OnReset();
						PopModal("optionsmenu");
					end
			},

			
			SetStyle(SliderStyle),
			Slider
			{
				name="sfxlevelslider",
				x = kCenter,
				y = 110,
				w = 270,
			};
			
			Slider
			{
				name="musiclevelslider",
				x = kCenter,
				y = 175,
				w = 270,
			};
		},
	},
}